/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images.legacy;

import com.andavin.images.data.DataManager;
import com.andavin.images.image.CustomImage;
import com.andavin.images.legacy.image.LegacyImage;
import com.andavin.images.legacy.image.LegacyImageSection;
import com.andavin.util.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;

public final class LegacyImportManager {
    public static List<CustomImage> importImages(File imageFolder, DataManager dataManager) throws IllegalStateException {
        File dataFile = new File(imageFolder, "data.yml");
        if (!dataFile.exists()) {
            throw new IllegalStateException("\u00a7cNo legacy data file exists.\n\u00a7aThe\u00a7f data.yml\u00a7c file must be in the Images directory");
        }
        LegacyImage.dataFolder = imageFolder;
        ConfigurationSerialization.registerClass(LegacyImage.class);
        ConfigurationSerialization.registerClass(LegacyImageSection.class);
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
        List images = (List)data.get("images");
        ArrayList<CustomImage> importedImages = new ArrayList<CustomImage>(images.size());
        for (LegacyImage legacyImage : images) {
            File file = legacyImage.getImageFile();
            BlockFace direction = null;
            for (Map.Entry<Location, LegacyImageSection> entry : legacyImage.getImageSections().entrySet()) {
                Location location = entry.getKey();
                LegacyImageSection section = entry.getValue();
                location.getWorld().loadChunk(location.getBlockX() >> 4, location.getBlockZ() >> 4);
                for (Entity entity : location.getWorld().getNearbyEntities(location, 1.0, 1.0, 1.0)) {
                    Location loc;
                    if (!(entity instanceof ItemFrame) || (loc = entity.getLocation()).getBlockX() != location.getBlockX() || loc.getBlockY() != location.getBlockY() || loc.getBlockZ() != location.getBlockZ()) continue;
                    entity.remove();
                    if (direction != null) continue;
                    direction = ((ItemFrame)entity).getFacing();
                }
            }
            if (direction == null) {
                Logger.warn("Image has an unknown direction and cannot be imported.");
                continue;
            }
            if (file.exists()) {
                Logger.info("Importing legacy image {} facing {}...", file.getName(), direction);
                try {
                    CustomImage image = new CustomImage(file.getName(), legacyImage.getLocation(), direction, ImageIO.read(file));
                    dataManager.save(image);
                    importedImages.add(image);
                }
                catch (IOException e) {
                    Logger.severe(e);
                }
                continue;
            }
            Logger.warn("Image {} no longer exists. Skipping...", file.getName());
        }
        return importedImages;
    }
}

